//by Thomas Lendl 2021
/*
requirements: FeatureJ Plugin (install via Update Site "ImageScience")
This Macro assembles and analyzes fluorescent images in 2D-mrxs-format exported via CaseViewer.
You need to put the folders containing the image files below two steps in the folder hierarchy and 
choose this above folder for the run.

The Macro will segment the nuclei on Dapi, enlarge them to an estimated cell size and Measure the 
Spotnumber per cell on the first Channel (Cy5) and the the mean intensity on the third Channel (FITC/GFP)
Summary results show the number of cells per image as well as spotnumber inside and outside of the difined cell objecs.
*/
var enlarge = 3;

SpotThresh = 15;

Analysis=1;

run("Close All", "");

inDir = getDirectory("Choose Directory Containing Files ");
outDir = inDir;
folderList = getFileList(inDir);
//print(folderList[1]);

run("Colors...", "foreground=white background=black selection=yellow");

setBatchMode(true);
roiManager("Associate", "true");
//setBatchMode(true);


	CH1="Cy5_Single_Extended";
	CH2="DAPI_Q_Extended";
	CH3="FITC_Single_Extended";
	//CH4=Dialog.getString();



Slice1="_-4";
Slice2="_-2";
Slice3="_0";
Slice4="_2";
Slice5="_4";



//Loop over folders
for (a=0; a<folderList.length; a++){
	Folder = folderList[a];
	inFileCut = lengthOf(folderList[a])-1;
	//print(inFileCut);
	folderName=substring(folderList[a],0,inFileCut);
	print("folderName = "+folderName);
	fileList = getFileList(inDir+folderName);

//Define Output
	TotalNuclei = newArray(fileList.length);
	TotalSpots = newArray(fileList.length);
	InsideSpots = newArray(fileList.length);
	NameList = newArray(fileList.length);

//Set global Variables:

	var Nuclei = 0;
	var Spots = 0;
	var SpotsTotal = 0;
	var SpotsInside = 0;
	Count = 0;

//Check if folderList[a] is a folder
	runFolder = 0;
	matching = (endsWith(folderList[a], "\\"));
	if (matching == 1) runFolder = 1;
	matching = (endsWith(folderList[a], "/"));
	if (matching == 1) runFolder = 1;

	if(runFolder == 1){

	print(folderList[a]);

		
		for (f=0; f<fileList.length; f++){

			////Cut Imagename
			subFolder = fileList[f];
			inFileCut = lengthOf(fileList[f])-1;
			print(inFileCut);
			subFolderNameBlanks = substring(fileList[f],0,inFileCut);
			subFolderName = replace(subFolderNameBlanks, " ","_");
			print("subFolderName = "+subFolderName);
			
			////Check if tiff-folder is present
			inDirSub = inDir + Folder + fileList[f];
			fileListSub = getFileList(inDirSub);	
			Sub = 0;
			for (x=0; x<fileListSub.length; x++){
				Find = fileListSub[x];
				//print("Subfile ="+Find);
				matching = (endsWith(Find, ".tif"));
				if (matching == 1) Sub = 1;
				else {
				}
			}			
	
			if(Sub == 1){
		
		//loop over files
				for (i=0; i<fileListSub.length; i++){
						
					////Cut Imagename
					Name=fileListSub[i];
					file = inDirSub + fileListSub[i];
					print(fileListSub[i]); 
					Slicecut = lengthOf(Slice1);
					print(Name);
				
					////Check for Filename
					Run = 0;
					matching=(endsWith(Name, CH1 + ".tif"));
					if (matching==1) {
						Run=1;	
						matching=(lastIndexOf(Name, CH1));
						inFileCut = matching;
						saveName=substring(fileListSub[i],0,inFileCut);

					}
					else {};


				
					////Open files to merge
					if (Run == 1){
						roiManager("reset");
						
						////Open and save projection image
						projCH1 = inDirSub + saveName + CH1 + ".tif"  ;
						run("Bio-Formats Importer", "open=["+projCH1+"] color_mode=Default rois_import=[ROI manager] view=Hyperstack stack_order=XYCZT");
						rename("projCH1");

						projCH2 = inDirSub + saveName + CH2 + ".tif"  ;
						run("Bio-Formats Importer", "open=["+projCH2+"] color_mode=Default rois_import=[ROI manager] view=Hyperstack stack_order=XYCZT");
						rename("projCH2");

						projCH3 = inDirSub + saveName + CH3 + ".tif"  ;
						run("Bio-Formats Importer", "open=["+projCH3+"] color_mode=Default rois_import=[ROI manager] view=Hyperstack stack_order=XYCZT");
						rename("projCH3");
						
						run("Duplicate...", "title=Outline duplicate channels=1");
						setAutoThreshold("Default");
						setThreshold(1, 255);
						run("Convert to Mask");
	
						run("Merge Channels...", "c1=projCH1 c2=projCH2 create");	
						Stack.setChannel(1);	
						resetMinAndMax();
						run("Red");	
						Stack.setChannel(2);	
						resetMinAndMax();	
						run("Grays");
						rename("Composite");

						TotalspotAnalysis();			
						TotalNuclei[Count] = Nuclei;
						TotalSpots[Count] = SpotsTotal;
						InsideSpots[Count] = SpotsInside;
						NameList[Count] = subFolderName;
						print("FolderName ="+subFolderName);


						//Analyze for Single Cells
						RoiNr = roiManager("count");
						SpotNr = newArray(RoiNr);
						MeanSignal = newArray(RoiNr);
						BorderObject = newArray(RoiNr);
						selectWindow("Spots Maxima");
		
						for (r = 0; r < RoiNr; r++) {
							run("Clear Results");
							roiManager("Select", r);
							SpotNr[r] = getValue("RawIntDen")/255;
							
						}

						selectWindow("projCH3");
						for (r = 0; r < RoiNr; r++) {
							run("Clear Results");
							roiManager("Select", r);
							MeanSignal[r] = getValue("Mean");
							run("Enlarge...", "enlarge=1 pixel");
							MinCurrent = getValue("Min");
							if (MinCurrent == 0){
							BorderObject[r] = 1;
							}
						}

						for (r = 0; r < RoiNr; r++) {
							setResult("Spotnumber", r, SpotNr[r]);
							setResult("Mean Value", r, MeanSignal[r]);
							setResult("Border Object", r, BorderObject[r]);
						}
					
						saveAs("Results", inDir + subFolderName + "_results.xls");
						run("Close All");
						Count++;
						}	
						
						else{};

				
					}
				}
			}
		run("Clear Results");
		
		for(i=0; i<=Count-1; i++){
			setResult("File", i, NameList[i]);
			setResult("Nuclei ", i, TotalNuclei[i]);
			setResult("Spots_Total", i, TotalSpots[i]);
			setResult("Spots_Inside", i, InsideSpots[i]);
			setResult("Spots_Outside", i, TotalSpots[i] - InsideSpots[i]);
			
		}
Exit()
		saveAs("Results", inDir + folderName + "_results.xls");
	}
	else{};

}

run("Close All");
exit


 
function TotalspotAnalysis(){
run("Set Measurements...", "area mean standard centroid display redirect=None decimal=3");
	selectWindow("Composite");
	run("Duplicate...", "duplicate channels=2");
	rename("Nuclei");
	selectWindow("Composite");
	run("Duplicate...", "duplicate channels=1");
	rename("Spots");
	selectWindow("Nuclei");
	run("FeatureJ Laplacian", "compute smoothing=8");
	rename("Mask");
	setAutoThreshold("Triangle");
	setOption("BlackBackground", true);
	run("Convert to Mask");
	run("Watershed");

////////Dilate Objects
	run("Select None");
	run("Duplicate...", "title=Voronoi");
	run("Voronoi");

	//setAutoThreshold("Default");
	//run("Threshold...");
	setThreshold(1, 255);
	//setThreshold(1, 255);
	setOption("BlackBackground", true);
	run("Convert to Mask");
	selectWindow("Mask");
	run("Create Selection");
	run("Enlarge...", "enlarge="+enlarge+"");
	setForegroundColor(255, 255, 255);
	run("Fill", "slice");
	imageCalculator("AND", "Mask","Outline");

	imageCalculator("Subtract", "Mask","Voronoi");
	close("Voronoi");
	selectWindow("Mask");
	run("Analyze Particles...", "size=20-Infinity circularity=0.50-1.00 display clear add");
	Nuclei=nResults;
	run("Select All");
	setBackgroundColor(0, 0, 0);
	run("Clear", "slice");
	roiManager("Fill");
	roiManager("Deselect");
	//Exit()
	saveAs("Tiff", inDir + Folder + subFolderName + "_" + CH2);
	rename("Mask");
	print(inDir + folderName + subFolderName);
	run("Clear Results");

	selectWindow("Spots");
	//Count total Number of Spots
	run("Find Maxima...", "prominence="+SpotThresh+" output=Count");
	SpotsTotal=getResult("Count", 0);

	selectWindow("Mask");
	run("Select None");
	run("Create Selection");
	selectWindow("Spots");
	run("Restore Selection");
	print(SpotsTotal);
	//Count Spots inside Cells
	run("Clear Results");
	run("Find Maxima...", "prominence="+SpotThresh+" output=Count");
	SpotsInside=getResult("Count", 0);
	print(SpotsInside);
	run("Select None");
	run("Find Maxima...", "prominence="+SpotThresh+" output=[Point Selection]");
	run("Clear Results");
	saveAs("Tiff", inDir + Folder + subFolderName + "_" + CH1);
	rename("Spots");
	run("Find Maxima...", "prominence=15 output=[Single Points]");

}



function Exit(){
	setBatchMode("show all");
	exit();
}

